% ex5_1.m
% Example 5.1 
% Fig. 5.1

clear
N=250;
q=0.36;
r=0.25;
a=0.9;
b=1;
t=0:1:N;
x=zeros(1,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
u=2.0*randn(1,N+1);
x(1,1)=0;
x(2,1)=a;
x(3,1)=b;
% data generation
for i=1:N
x(1,i+1)= a*x(1,i) + b*u(1,i)+w(1,i);
y(1,i)=x(1,i) + v(1,i);
x(2,i+1)=x(2,i);
x(3,i+1)=x(3,i);
end
y(1,N+1)=x(1,N+1)+v(1,N+1);
%
% EKF
var1=zeros(1,N+1);
var2=zeros(1,N+1);
var3=zeros(1,N+1);
% 
H=[1 0 0];
q1=0;
q2=0;
Q=[q 0 0;
   0 q1 0;
   0 0 q2];
xep=zeros(3,N+1);  % prediction xe_{t/t-1}
xef=zeros(3,N+1);  % filtering  xe_{t/t}
Pep=zeros(3,3,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(3,3,N+1);  % covariance of filtering P_{t/t}
Pep(:,:,1)=[4 0 0;
            0 4 0;
            0 0 4];  % initial covariance of prediction
K=zeros(3,1,N+1);
for i=1:N+1
K(:,:,i)=Pep(:,:,i)*H'/(H*Pep(:,:,i)*H'+r);   % EKF gain
xef(:,i)=xep(:,i) + K(:,:,i)*(y(i)-H*xep(:,i)); 
Pef(:,:,i)=Pep(:,:,i)-K(:,:,i)*H*Pep(:,:,i);
F=[xef(2,i) xef(1,i) u(1,i);
0  1  0;
0  0  1];
Pep(:,:,i+1)=F*Pef(:,:,i)*F' + Q;   % covarinace of prediction
xep(1,i+1)=xef(2,i)*xef(1,i)+xef(3,i)*u(1,i);    % predicted estimate
xep(2,i+1)=xef(2,i);
xep(3,i+1)=xef(3,i);
var1(i)=Pef(1,1,i);
var2(i)=Pef(2,2,i);
var3(i)=Pef(3,3,i);
end

figure(1)
plot(t,x(2,1:N+1),'r',t,xef(2,1:N+1),'b-','LineWidth',1.5)
title('Fig. 5.1a: Estimation of a')
xlabel('Number of steps t')
axis([0,N,-1,2]);
grid
legend('True a=0.9','Estimate a_{t|t}')
hold on

figure(2)
plot(t,x(3,1:N+1),'r',t,xef(3,1:N+1),'b-','LineWidth',1.5)
title('Fig. 5.1b: Estimation of b')
xlabel('Number of steps t')
axis([0,N,-1,2]);
grid
legend('True b=1.0','Estimate b_{t|t}')
hold on

figure(3)
semilogy(t,var1,'b',t,var2,'r',t,var3,'g','LineWidth',1.5)
axis([0,N,0,5]);
title('Fig. 5.1c: Variances of estimation errors')
xlabel('Number of steps t')
legend('P_{xx}','P_{aa}','P_{bb}')
grid
hold on

figure(4)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'gx-',t,xef(1,1:N+1),'bo-',...
    'LineWidth',1.4)
xlabel('Number of steps t')
title('Fig. 5.1d: Filtering')
axis([0,N,-15,15]);
grid
legend('True x_t','Observation y_t','Filtered estimate x_{t|t}')
